/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.minecolonies.api.loot.ModLootConditions;
import net.minecraft.entity.Entity;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import net.minecraft.world.biome.Biome;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityInBiomeCategory
implements ILootCondition {
    @Nullable
    private final Biome.Category category;

    private EntityInBiomeCategory(@Nullable Biome.Category category) {
        this.category = category;
    }

    public static ILootCondition.IBuilder any() {
        return () -> new EntityInBiomeCategory(null);
    }

    public static ILootCondition.IBuilder of(@NotNull Biome.Category category) {
        return () -> new EntityInBiomeCategory(category);
    }

    @NotNull
    public LootConditionType func_230419_b_() {
        return ModLootConditions.entityInBiomeCategory;
    }

    public boolean test(@NotNull LootContext lootContext) {
        if (this.category == null) {
            return true;
        }
        Entity entity = (Entity)lootContext.func_216031_c(LootParameters.field_216281_a);
        if (entity != null && entity.field_70170_p != null) {
            Biome biome = entity.field_70170_p.func_226691_t_(entity.getEntity().func_233580_cy_());
            return biome.func_201856_r().equals((Object)this.category);
        }
        return false;
    }

    public static class Serializer
    implements ILootSerializer<EntityInBiomeCategory> {
        public void serialize(@NotNull JsonObject json, @NotNull EntityInBiomeCategory condition, @NotNull JsonSerializationContext context) {
            if (condition.category != null) {
                json.addProperty("category", condition.category.func_176610_l());
            }
        }

        @NotNull
        public EntityInBiomeCategory deserialize(@NotNull JsonObject json, @NotNull JsonDeserializationContext context) {
            String categoryId = JSONUtils.func_151219_a((JsonObject)json, (String)"category", (String)"");
            Biome.Category category = Biome.Category.func_235103_a_((String)categoryId);
            return new EntityInBiomeCategory(category);
        }
    }
}

